/*****************************************************************************
*                           Freescale Semiconductor                          *

*                                                                            *
*  Project    : M56F8006 Modular Pixel Matrix                                                  *
*  Version    : 0.1                                                          *
*  Date       : 11/Apr/2009                                                  *
*  Authors     : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Martins, Leonardo Mangiapelo                        *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
*                                                                            *
*    M56F8006 Modular Pixel Matrix												                                     * 
*                                                                            *
******************************************************************************/

#ifndef __MAIN_H
#define __MAIN_H    1

// Define macros to use portions of NOINIT section as variables
#define pwm_reload_cnt  noinit16[0]

// Control PWM external pin configuration via macro
#define PWM_OUT_CFG     0

// Use HW or SW to drive pwm outputs
#define PWM_HW_DRIVE    (PWM_OUT_PAD_EN)
#define PWM_SW_DRIVE    (PWM_OUT_PAD_EN|PWM_OUT_OUTCTL0|PWM_OUT_OUTCTL1|PWM_OUT_OUTCTL2|PWM_OUT_OUTCTL3|PWM_OUT_OUTCTL4|PWM_OUT_OUTCTL5)

// Need to tell Mike Stanley about bad bitmask "PWM_OUT_OUt5"
#define PWM_OUT_OUTCTL  (PWM_OUT_OUTCTL0|PWM_OUT_OUTCTL1|PWM_OUT_OUTCTL2|PWM_OUT_OUTCTL3|PWM_OUT_OUTCTL4|PWM_OUT_OUTCTL5)
#define PWM_OUT_OUT     (PWM_OUT_OUT0|PWM_OUT_OUT1|PWM_OUT_OUT2|PWM_OUT_OUT3|PWM_OUT_OUT4|PWM_OUT_OUt5)

// Global Variables


// Function Prototypes
extern void main(void);
//extern void pwm_ctrl(uint16_t mod, uint16_t v0, uint16_t v1, uint16_t v2);


#endif  __MAIN_H

/* End of "main.h" */

